<?php

declare(strict_types=1);

namespace Erlage\Photogram\Exceptions;

use Exception;

/**
 * Exception that's throwed when system fails to create a data model
 * from data provided. usually happens when database query returns
 * data that's not parsable or not complete or simply data doesn't
 * exists i.e null returned from database and model creation failed
 */
final class ModelDataException extends Exception
{
    public function __construct(string $message)
    {
        parent::__construct($message);
    }
}
